;
; AutoHotkey Version: 1.x
; Language:       English
; Platform:       Win9x/NT
; Author:         David Tong 08-03-2008
;
; Script Function:
;  Mounts Z on either TM5 or U100 as ap-propriate. (Checks to see which machine
;  it's running on.
;
;  29-09-2008  Added auto refresh for RH toolbar
;  07-10-2008  Added test for prior presence of mounted drive

#NoEnv  ; Recommended for performance and compatibility with future AutoHotkey releases.
SendMode Input  ; Recommended for new scripts due to its superior speed and reliability.
SetWorkingDir %A_ScriptDir%  ; Ensures a consistent starting directory.

IfInString , A_ComputerName , TM5 
	File = D:\TCTM5		;uses this line for TM5	
IfInString , A_ComputerName , U100
	File = D:\TCU100	;uses this line for U100
IfInString , A_ComputerName , R500
	File = D:\TCR500	;uses this line for R500 ; line added for R500 27-05-2008

Title = MountZ
xloc := A_ScreenWidth - 600	 	;Calculate x coordinate of Progress window
yloc := A_ScreenHeight - 100	;Calculate y coordinate of Progress window
Progress, B2 x%xloc% Y%yloc% M zh0 w400 h50 c00, , %Title%, %Title% , 	; Defines Progress window for rest of program

IfNotExist , Z:\
	Gosub , Mount
Gosub , Refresh
ExitApp

;;;;;;;;;;;;;;;;;;;;;;;
;
; Subroutines
;
Mount:
Progress , , Mounting %File% as Z on %A_ComputerName%.
RunWait , "C:\Program Files\TrueCrypt\TrueCrypt.exe" /q /m  /auto  /letter z /v %File%
Return
;
;;;;;;;;;;;;;;;;;;;;;;;
; Function to return ExactClassName of TLB popup window. (Differs between XP and Vista)
;
GetTLBname()
{
    IfInString , A_OSVersion , WIN_VISTA
        Return , "TrueLaunchBarMenuShadow"
    IfInString , A_OSVersion , WIN_XP
        Return , "TrueLaunchBarMenu"
}
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
Refresh:
Name := GetTLBname()
Progress, , RH Toolbar refreshed.
IfWinNotExist , ahk_class %Name% ;
{
	SendInput , !z	;Alt-Z to show toolbar - briefly before WindowPad closes it again
}
SendInput , ^{F5}	;Ctrl-F5 to refresh toolbar
sleep , 1000 ; to display message
Return
;
;;;;;;;;;;;;;;;;;;;