﻿function ShiftCharMap ([string]$text, [int]$shift, [char]$from = 0x0000, [char]$to = 0xFFFF) {
	$output = $null
	foreach ($char in $text.toCharArray()) {
		$unicode = [int]$char
		if (($unicode -ge $from) -and ($unicode -le $to)) {
			$output += [char]((0xFFFF + $unicode + $shift % 0xFFFF) % 0xFFFF)
		} else {
			$output += $char
		}
	}
	return $output
}

# http://forum.tordex.com/viewtopic.php?f=15&t=2641&sid=fb6c3639910c106c4b9689b2d53f629a
$s = "Â ýòîé âåòêå ìîãóò îáñóæäàòüñÿ ëþáûå âîïðîñû, ñâÿçàííûå ñ True Launch Bar. ßçûê ïîñòîâ - ðóññêèé. Ðåêîìåíäóåòñÿ â ïðîôèëå óñòàíîâèòü ðóññêèé ÿçûê."

ShiftCharMap $s 848 0x00C0 0x00FF