#include "StdAfx.h"
#include "propertiesdlg.h"
#include "resource.h"

CPropertiesDlg::CPropertiesDlg(void): CTrueDialog(IDD_PROPERTIES)
{
}

CPropertiesDlg::~CPropertiesDlg(void)
{
}

int CALLBACK MyEnumFonts(ENUMLOGFONTEX *lpelfe, NEWTEXTMETRICEX *lpntme, DWORD FontType, LPARAM lParam)
{
	HWND hwndCB = (HWND) lParam;
	if(SendMessage(hwndCB, CB_FINDSTRING, NULL, (LPARAM) lpelfe->elfFullName) == CB_ERR)
	{
		SendMessage(hwndCB, CB_ADDSTRING, NULL, (LPARAM) lpelfe->elfFullName);
	}
	return TRUE;
}

void CPropertiesDlg::OnInitDialog(void)
{
    m_LightColor.SubClassWindow(GetDlgItem(m_hWnd, IDC_HIGHLIGHTCOLOR), m_props.m_LigthColor);
    m_SelectedColor.SubClassWindow(GetDlgItem(m_hWnd, IDC_SELCOLOR), m_props.m_SelectedColor);
    m_UnSelectedColor.SubClassWindow(GetDlgItem(m_hWnd, IDC_UNSELCOLOR), m_props.m_UnSelectedColor);
    m_FreeDesktopColor.SubClassWindow(GetDlgItem(m_hWnd, IDC_FREECOLOR), m_props.m_FreeColor);

	HDC hdc = GetDC(m_hWnd);
	LOGFONT lf;
	ZeroMemory(&lf, sizeof(lf));
	lf.lfCharSet = DEFAULT_CHARSET;
	EnumFontFamiliesEx(hdc, &lf, (FONTENUMPROC) MyEnumFonts, (LPARAM) GetDlgItem(m_hWnd, IDC_FONT), 0);
	ReleaseDC(m_hWnd, hdc);

	int idx = SendDlgItemMessage(m_hWnd, IDC_FONT, CB_FINDSTRING, NULL, (LPARAM) m_props.fontName);
	if(idx != CB_ERR)
	{
		SendDlgItemMessage(m_hWnd, IDC_FONT, CB_SETCURSEL, idx, 0);
	}// else
	{
		SetDlgItemText(m_hWnd, IDC_FONT, m_props.fontName);
	}

	SendDlgItemMessage(m_hWnd, IDC_SPIN_COLS, UDM_SETRANGE, 0, (LPARAM) MAKELONG((short) 9, (short) 1));
	SendDlgItemMessage(m_hWnd, IDC_SPIN_COLS, UDM_SETPOS, 0, (LPARAM) MAKELONG((short) m_props.m_cols, (short) 0));

	SendDlgItemMessage(m_hWnd, IDC_SPIN_COUNT_DESKTOP, UDM_SETRANGE, 0, (LPARAM) MAKELONG((short) 9, (short) 1));
	SendDlgItemMessage(m_hWnd, IDC_SPIN_COUNT_DESKTOP, UDM_SETPOS, 0, (LPARAM) MAKELONG((short) m_props.m_desktops, (short) 0));
}

BOOL CPropertiesDlg::OnEndDialog(void)
{
	LoadProperties(&m_props);
    return TRUE;
}


void CPropertiesDlg::OnCommand(DWORD itemID)
{
	switch(LOWORD(itemID))
	{
    case IDC_HIGHLIGHTCOLOR:
	case IDC_SELCOLOR:
	case IDC_UNSELCOLOR:
	case IDC_FREECOLOR:
		{
			if(HIWORD(itemID) == BN_CLICKED)
			{
//				RepaintButton();
			}
		}
		break;
	case IDC_FONT:
		{
			if(HIWORD(itemID) == CBN_SELCHANGE)
			{
//				RepaintButton();
			}
		}
	}
}

void CPropertiesDlg::OnPaint(void)
{
}

void CPropertiesDlg::LoadProperties(BTN_PROPERTIES* props)
{
	props->m_FreeColor       = m_FreeDesktopColor.GetColor();
    props->m_LigthColor      = m_LightColor.GetColor();
    props->m_SelectedColor   = m_SelectedColor.GetColor();
    props->m_UnSelectedColor = m_UnSelectedColor.GetColor();

	GetDlgItemText(m_hWnd, IDC_FONT, props->fontName, sizeof(props->fontName));

	props->m_cols = 0xFFFF & SendDlgItemMessage(m_hWnd, IDC_SPIN_COLS, UDM_GETPOS, 0, 0);
	if(!props->m_cols) 
    {
        props->m_cols = 1;
    }

	props->m_desktops = 0xFFFF & SendDlgItemMessage(m_hWnd, IDC_SPIN_COUNT_DESKTOP, UDM_GETPOS, 0, 0);
	if(!props->m_desktops) 
    {
        props->m_desktops = 1;
    }

    if( props->m_cols > props->m_desktops )
    {
        props->m_cols = props->m_desktops;
    }
}

