// TrueDialog.cpp: implementation of the CTrueDialog class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "global.h"
#include "TrueDialog.h"
#include <stdio.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTrueDialog::CTrueDialog(DWORD DialogID)
{
	m_hWnd = NULL;
	m_DialogID = DialogID;
	m_hResInst = NULL;
}

CTrueDialog::~CTrueDialog()
{
}


LRESULT CALLBACK CTrueDialog::WndProc(HWND hWnd, UINT uMessage, WPARAM wParam, LPARAM lParam)
{
	CTrueDialog *pThis = (CTrueDialog*)GetWindowLong(hWnd, GWL_USERDATA);

	if(pThis || uMessage == WM_INITDIALOG)
	{
		switch (uMessage)
		{
		case WM_INITDIALOG:
			{
				pThis = (CTrueDialog*)(lParam);
				SetWindowLong(hWnd, GWL_USERDATA, (LONG)pThis);

				//set the window handle
				pThis->m_hWnd = hWnd;
				pThis->OnInitDialog();
			}
			return TRUE;
		case WM_NOTIFY:
			return pThis->OnNotify((int) wParam, (LPNMHDR) lParam);
		case WM_COMMAND:
			{
				switch(LOWORD(wParam))
				{
				case IDOK:
					if(pThis->OnEndDialog())
					{
						EndDialog(pThis->m_hWnd, IDOK);
					}
					break;
				case IDCANCEL:
					EndDialog(pThis->m_hWnd, IDCANCEL);
					break;
				default:
					pThis->OnCommand(wParam);
					break;
				}
			}
			return TRUE;
		case WM_PAINT:
			pThis->OnPaint();
			break;
		case WM_CTLCOLORSTATIC:
			{
				LRESULT res = SendMessage((HWND) lParam, WM_CTLCOLORSTATIC, wParam, lParam);
				return res;
			}
			break;
		default:
			{
				BOOL needReturn;
				LRESULT ret = pThis->OnOtherMessage(uMessage, wParam, lParam, &needReturn);
				if(needReturn)
				{
					return ret;
				}
			}
			break;
		}
	}

	return FALSE;
}

LRESULT CALLBACK CTrueDialog::WndProcPP(HWND hWnd, UINT uMessage, WPARAM wParam, LPARAM lParam)
{
/*	CTrueDialog *pThis = (CTrueDialog*)GetWindowLong(hWnd, GWL_USERDATA);

	if(pThis || uMessage == WM_INITDIALOG)
	{
		switch (uMessage)
		{
		case WM_INITDIALOG:
			{
				PROPSHEETPAGE* pp = (PROPSHEETPAGE*)lParam;
				pThis = (CTrueDialog*)(pp->lParam);
				SetWindowLong(hWnd, GWL_USERDATA, (LONG)pThis);

				//set the window handle
				pThis->m_hWnd = hWnd;
				pThis->OnInitDialog();
			}
			return TRUE;
		case WM_NOTIFY:
			return pThis->OnNotify((int) wParam, (LPNMHDR) lParam);
		case WM_COMMAND:
			{
				switch(LOWORD(wParam))
				{
				case IDOK:
					if(pThis->OnEndDialog())
					{
						EndDialog(pThis->m_hWnd, IDOK);
					}
					break;
				case IDCANCEL:
					EndDialog(pThis->m_hWnd, IDCANCEL);
					break;
				default:
					pThis->OnCommand(wParam);
					break;
				}
			}
			return TRUE;
		case WM_PAINT:
			pThis->OnPaint();
			break;
		case WM_CTLCOLORSTATIC:
			{
				if(GetProp((HWND) lParam, "StaticLink"))
				{
					LRESULT res = SendMessage((HWND) lParam, WM_CTLCOLORSTATIC, wParam, lParam);
					return (LRESULT) GetStockObject(HOLLOW_BRUSH);
				}
			}
			break;
		default:
			{
				BOOL ret = FALSE;
				HRESULT res = pThis->OnOtherMessage(uMessage, wParam, lParam, &ret);
				if(ret)
				{
					return res;
				}

			}
		}
	}*/

	return FALSE;
}

void CTrueDialog::OnInitDialog()
{

}

BOOL CTrueDialog::OnEndDialog()
{
	return TRUE;
}

void CTrueDialog::OnCommand(DWORD itemID)
{

}

void CTrueDialog::OnPaint()
{

}

int CTrueDialog::DoModal(HWND parent, HINSTANCE g_hResInst)
{
	m_hResInst = g_hResInst;
	char strRes[50];
	sprintf(strRes, "#%d", m_DialogID);
	HRSRC resDlg = FindResource(g_hResInst, strRes, RT_DIALOG);
	HGLOBAL hDlgGlobal = NULL;
	if(!resDlg)
	{
		resDlg = FindResource(g_hInst, strRes, RT_DIALOG);
		if(!resDlg) return NULL;
		hDlgGlobal = LoadResource(g_hInst, resDlg);
	} else
	{
		hDlgGlobal = LoadResource(g_hResInst, resDlg);
	}

	if(!hDlgGlobal)
	{
		return NULL;
	}

	DLGTEMPLATE* dlgTempl = (DLGTEMPLATE*) LockResource(hDlgGlobal);
	if(!dlgTempl) 
	{
		FreeResource(hDlgGlobal);
		return NULL;
	}

	int ret = DialogBoxIndirectParam(g_hResInst, dlgTempl, parent, (DLGPROC) CTrueDialog::WndProc, (LPARAM) this);
	FreeResource(hDlgGlobal);

	return ret;
}

HWND CTrueDialog::Create(HWND hWndParent, HINSTANCE g_hResInst)
{
	char strRes[50];
	sprintf(strRes, "#%d", m_DialogID);
	HRSRC resDlg = FindResource(g_hResInst, strRes, RT_DIALOG);
	HGLOBAL hDlgGlobal = NULL;
	if(!resDlg)
	{
		resDlg = FindResource(g_hInst, strRes, RT_DIALOG);
		if(!resDlg) return NULL;
		hDlgGlobal = LoadResource(g_hInst, resDlg);
	} else
	{
		hDlgGlobal = LoadResource(g_hResInst, resDlg);
	}

	if(!hDlgGlobal)
	{
		return NULL;
	}

	DLGTEMPLATE* dlgTempl = (DLGTEMPLATE*) LockResource(hDlgGlobal);
	if(!dlgTempl) 
	{
		FreeResource(hDlgGlobal);
		return NULL;
	}

	m_hWnd = CreateDialogIndirectParam(g_hInst, dlgTempl, hWndParent, (DLGPROC) CTrueDialog::WndProc, (LPARAM) this);
	UnlockResource(hDlgGlobal);
	FreeResource(hDlgGlobal);
	return m_hWnd;
}

DWORD CTrueDialog::OnNotify(int idCtrl, LPNMHDR pnmh)
{
	return 0;
}




void CTrueDialog::GetChildRect(DWORD ID, RECT *rc)
{
	HWND wnd = GetDlgItem(m_hWnd, ID);
	GetChildRect(wnd, rc);
}

void CTrueDialog::GetChildRect(HWND wnd, RECT *rc)
{
	RECT r;
	GetWindowRect(wnd, &r);

	POINT pt;
	pt.x = r.left; pt.y = r.top;
	ScreenToClient(m_hWnd, &pt);
	r.left = pt.x; r.top = pt.y;

	pt.x = r.right; pt.y = r.bottom;
	ScreenToClient(m_hWnd, &pt);
	r.right = pt.x; r.bottom = pt.y;

	*rc = r;
}

LPCDLGTEMPLATE CTrueDialog::GetTemplate(HINSTANCE g_hResInst)
{
	char strRes[50];
	sprintf(strRes, "#%d", m_DialogID);
	HRSRC resDlg = FindResource(g_hResInst, strRes, RT_DIALOG);
	HGLOBAL hDlgGlobal = NULL;
	if(!resDlg)
	{
		resDlg = FindResource(g_hInst, strRes, RT_DIALOG);
		if(!resDlg) return NULL;
		hDlgGlobal = LoadResource(g_hInst, resDlg);
	} else
	{
		hDlgGlobal = LoadResource(g_hResInst, resDlg);
	}

	if(!hDlgGlobal)
	{
		return NULL;
	}

	DLGTEMPLATE* dlgTempl = (DLGTEMPLATE*) LockResource(hDlgGlobal);
	if(!dlgTempl) 
	{
		FreeResource(hDlgGlobal);
		return NULL;
	}
	return dlgTempl;
}

LRESULT CTrueDialog::OnOtherMessage(UINT uMessage, WPARAM wParam, LPARAM lParam, BOOL *ret)
{
	*ret = FALSE;
	return 0;
}
