// VirtualDesktop.cpp: implementation of the CVirtualDesktop class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VirtualDesktop.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CVirtualDesktop virtualDesktop;

//=========================================
//
//=========================================
CVirtualDesktop::CVirtualDesktop() : m_activeDesktop(0)
{
    memset(m_countWindow, 0, sizeof(m_countWindow) );
    memset(m_windowList, 0, sizeof(m_windowList) );
}

//=========================================
//
//=========================================
CVirtualDesktop::~CVirtualDesktop()
{

}

//=========================================
//
//=========================================
void CVirtualDesktop::GetVDesktopWindow(int indexVDesktop, int indexWindow, CDesktopWindow* dWindow)
{
    assert(indexVDesktop < MAX_COUNT_DESKTOP);
    assert(indexVDesktop >= 0);
    
    assert(indexWindow >= 0);
    assert(indexWindow < MAX_COUNT_WINDOW);

    *dWindow = m_windowList[indexVDesktop][indexWindow];
}

//=========================================
//
//=========================================
void CVirtualDesktop::SetVDesktopWindow(int indexVDesktop, int indexWindow, const CDesktopWindow& dWindow)
{
    assert(indexVDesktop < MAX_COUNT_DESKTOP);
    assert(indexVDesktop >= 0);
    
    assert(indexWindow >= 0);
    assert(indexWindow < MAX_COUNT_WINDOW);

    m_windowList[indexVDesktop][indexWindow] = dWindow;
}

//=========================================
//
//=========================================
bool CVirtualDesktop::Create(int newCountDesktop)
{
    m_activeDesktop = 0;
    if( newCountDesktop > MAX_COUNT_DESKTOP )
    {
        newCountDesktop = MAX_COUNT_DESKTOP;
    }
    m_countDesktop  = newCountDesktop;

    memset(m_countWindow, 0, sizeof(m_countWindow) );
    memset(m_windowList, 0, sizeof(m_windowList) );

    return true;
}

//=========================================
//
//=========================================
bool CVirtualDesktop::SetCountDesktop(int newCountDesktop)
{
    if( newCountDesktop == m_countDesktop )
    {
        return true;
    }

    if( newCountDesktop > MAX_COUNT_DESKTOP )
    {
        newCountDesktop = MAX_COUNT_DESKTOP;
    }

    if( newCountDesktop > m_countDesktop )
    {
        m_countDesktop = newCountDesktop;
        return true;
    }

    //=================================
    //   
    //=================================
    //  
    for(int i = newCountDesktop; i < m_countDesktop; i++ )
    {
        if( m_countWindow[i] )
        {
            for(int j = m_countWindow[i] - 1 ; j >= 0; j-- )
            {
                ::ShowWindow( m_windowList[i][j].m_hwnd, SW_SHOW);
            }
        }
        m_countWindow[i] = 0;
    }

    //  
    m_countDesktop = newCountDesktop;

    return true;
}


//=========================================
//
//=========================================
const char TRUE_LAUNCNBAR_MENU[]   = "TrueLaunchBarMenu";
const char TRUE_LAUNCNBAR_SHADOW[] = "TrueLaunchBarShadow";

BOOL CALLBACK EnumWindowsProc( HWND hwnd,  LPARAM lParam )
{
    HWND tmpHWND = hwnd;

    if( ::IsWindowVisible(tmpHWND) )
    {
        char className[200];
        ::GetClassName(tmpHWND, className, 199);

        if( !strcmp(className, TRUE_LAUNCNBAR_MENU )  )
        {
            return TRUE;
        }

        if( !strcmp(className, TRUE_LAUNCNBAR_SHADOW )  )
        {
            return TRUE;
        }

        if( ( tmpHWND != virtualDesktop.m_hwndSysTray ) && 
            ( tmpHWND != virtualDesktop.m_hwndProgram ) &&
            ( tmpHWND != virtualDesktop.m_notHideWindow) )
        {
            virtualDesktop.m_windowList[virtualDesktop.m_activeDesktop]
                [virtualDesktop.m_countWindow[virtualDesktop.m_activeDesktop]].m_hwnd = tmpHWND;
            virtualDesktop.m_countWindow[virtualDesktop.m_activeDesktop]++;
        }
    }
        
	return TRUE;
}


//=========================================
//
//=========================================
bool CVirtualDesktop::ShowDesktop(int index, HWND notHideWindow)
{
    if( index >= MAX_COUNT_DESKTOP )
    {
        return false;
    }

    if( index == m_activeDesktop )
    {
        return true;
    }

    m_notHideWindow = notHideWindow;

    m_hwndSysTray = ::FindWindow("Shell_TrayWnd", NULL);
    m_hwndProgram = ::FindWindow("Progman", NULL);
    m_hwndDesktop = ::GetDesktopWindow();

    m_countWindow[m_activeDesktop] = 0;
    EnumWindows(EnumWindowsProc, 0);
    
    for(int i = 0; i < virtualDesktop.m_countWindow[m_activeDesktop]; i++ )
    {
        ::ShowWindow(m_windowList[m_activeDesktop][i].m_hwnd, SW_HIDE);
    }

    if( m_countWindow[index] )
    {
        for(int i = m_countWindow[index] - 1 ; i >= 0; i-- )
        {
            ::ShowWindow( m_windowList[index][i].m_hwnd, SW_SHOW);
        }
    }

    m_activeDesktop = index;

    return true;
}

///=========================================
//
//=========================================
bool CVirtualDesktop::ShowAllWindow()
{
    for(int index = 0; index < MAX_COUNT_DESKTOP; index++ )
    {
        if( m_countWindow[index] )
        {
            for(int i = m_countWindow[index] - 1 ; i >= 0; i-- )
            {
                ::ShowWindow( m_windowList[index][i].m_hwnd, SW_SHOW);
            }
        }
    }

    m_activeDesktop = 0;
    memset(m_countWindow, 0, sizeof(m_countWindow) );
    memset(m_windowList, 0, sizeof(m_windowList) );

    return true;
}
