#include "colorbutton.h"
#include "Global.h"
#include "WindowsX.h"
CColorButton::CColorButton(void)
{
	m_hWnd = NULL;
	oldWndProc = NULL;
	m_color = RGB(0, 0, 0xFF);
}

CColorButton::~CColorButton(void)
{
}


LRESULT CALLBACK CColorButton::WndProc(HWND hWnd, UINT uMessage, WPARAM wParam, LPARAM lParam)
{
	CColorButton* pThis = NULL;
	if(IsWindow(hWnd))
	{
		pThis = (CColorButton*)GetProp(hWnd, TEXT("CColorButtonThis"));
	}

	MSG msg;
	memset(&msg, 0, sizeof(msg));
	msg.hwnd = hWnd;
	msg.lParam = lParam;
	msg.message = uMessage;
	msg.wParam = wParam;
	LRESULT res = NULL;

	if(pThis)
	{
		switch (uMessage)
		{
		case 0x0128:
			return TRUE;
		case WM_PAINT:
			pThis->OnPaint();
			return TRUE;
		case WM_LBUTTONDOWN:
			pThis->OnClick();
			return TRUE;
		case WM_NCHITTEST:
			return HTCLIENT;
		case WM_MOUSEMOVE:
			return FALSE;
		case WM_USER + 1:
			pThis->m_color = wParam;
			SendMessage(GetParent(pThis->m_hWnd), WM_COMMAND, MAKELONG(GetDlgCtrlID(pThis->m_hWnd), BN_CLICKED), (LPARAM) pThis->m_hWnd);
			InvalidateRect(hWnd, NULL, TRUE);
			break;
		case WM_USER + 2:
			pThis->SelectColor();
			break;
		}
	}

	return CallWindowProc(pThis->oldWndProc, hWnd, uMessage, wParam, lParam);
}


void CColorButton::SubClassWindow(HWND hWnd, COLORREF color)
{
	m_color = color;
	m_hWnd = hWnd;
	SetProp(hWnd, TEXT("CColorButtonThis"), (HANDLE) this);
	oldWndProc = (WNDPROC) SetWindowLong(hWnd, GWL_WNDPROC, (LONG) CColorButton::WndProc);
}

void CColorButton::OnPaint(void)
{
	PAINTSTRUCT ps;
	BeginPaint(m_hWnd, &ps);

	COLORREF dkShadow = GetSysColor(COLOR_3DDKSHADOW);
	COLORREF Shadow = GetSysColor(COLOR_3DFACE);
	COLORREF ltShadow = GetSysColor(COLOR_3DHILIGHT);
	COLORREF arrow = GetSysColor(COLOR_BTNTEXT);

	HPEN penDkShadow = CreatePen(PS_SOLID, 1, dkShadow);
	HPEN penShadow = CreatePen(PS_SOLID, 1, Shadow);
	HPEN penLtShadow = CreatePen(PS_SOLID, 1, ltShadow);
	HPEN penArrow = CreatePen(PS_SOLID, 1, arrow);

	HBRUSH brColor = CreateSolidBrush(m_color);
	HBRUSH brShadow = CreateSolidBrush(Shadow);

	RECT rcClient;
	GetClientRect(m_hWnd, &rcClient);

	FillRect(ps.hdc, &rcClient, brColor);

	HPEN oldPen = (HPEN) SelectObject(ps.hdc, penLtShadow);
	MoveToEx(ps.hdc, rcClient.left, rcClient.bottom, NULL);
	LineTo(ps.hdc, rcClient.left, rcClient.top);
	LineTo(ps.hdc, rcClient.right, rcClient.top);
	
	SelectObject(ps.hdc, penDkShadow);
	LineTo(ps.hdc, rcClient.right, rcClient.bottom);
	LineTo(ps.hdc, rcClient.left, rcClient.bottom);

	rcClient.left++; rcClient.right--;
	rcClient.top++;  rcClient.bottom--;

	SelectObject(ps.hdc, penShadow);
	MoveToEx(ps.hdc, rcClient.left, rcClient.bottom, NULL);
	LineTo(ps.hdc, rcClient.left, rcClient.top);
	LineTo(ps.hdc, rcClient.right, rcClient.top);
	LineTo(ps.hdc, rcClient.right, rcClient.bottom);
	LineTo(ps.hdc, rcClient.left, rcClient.bottom);

	rcClient.left++; rcClient.right--;
	rcClient.top++;  rcClient.bottom--;

	SelectObject(ps.hdc, penDkShadow);
	MoveToEx(ps.hdc, rcClient.left, rcClient.bottom, NULL);
	LineTo(ps.hdc, rcClient.left, rcClient.top);
	LineTo(ps.hdc, rcClient.right, rcClient.top);

	SelectObject(ps.hdc, penLtShadow);
	LineTo(ps.hdc, rcClient.right, rcClient.bottom);
	LineTo(ps.hdc, rcClient.left, rcClient.bottom);

	rcClient.top = rcClient.bottom - 4;
	rcClient.left = rcClient.right - 6;
	SelectObject(ps.hdc, penLtShadow);
	MoveToEx(ps.hdc, rcClient.left, rcClient.bottom, NULL);
	LineTo(ps.hdc, rcClient.left, rcClient.top);
	LineTo(ps.hdc, rcClient.right, rcClient.top);

	rcClient.left++; rcClient.right++;
	rcClient.top++;  rcClient.bottom++;

	FillRect(ps.hdc, &rcClient, brShadow);

	int x = rcClient.left + 1;
	int y = rcClient.top + 1;
	SelectObject(ps.hdc, penArrow);

	MoveToEx(ps.hdc, x, y, NULL);
	LineTo(ps.hdc, x + 5, y);

	MoveToEx(ps.hdc, x + 1, y + 1, NULL);
	LineTo(ps.hdc, x + 4, y + 1);

	MoveToEx(ps.hdc, x + 2, y + 2, NULL);
	LineTo(ps.hdc, x + 3, y + 2);

	SelectObject(ps.hdc, oldPen);

	DeleteObject(penDkShadow);
	DeleteObject(penShadow);
	DeleteObject(penLtShadow);
	DeleteObject(brShadow);
	DeleteObject(brColor);
	DeleteObject(penArrow);

	EndPaint(m_hWnd, &ps);
}

CColorPicker::CColorPicker(void)
{
	m_color = 0;
	m_hWnd = NULL;
	selectedX = -1;
	selectedY = -1;

	int rVal = 0;
	int gVal = 0;
	int bVal = 0;
	for(DWORD i=0; i < 12; i++)
	{
		for(DWORD j=0; j < 18; j++)
		{
			m_colors[i][j] = RGB(rVal * 0x33, gVal * 0x33, bVal * 0x33);
			gVal++;
			if(gVal >= 6)
			{
				gVal = 0;
				rVal++;
				if(rVal >= 6)
				{
					rVal = 0;
					bVal++;
				}
			}
		}
	}
}

CColorPicker::~CColorPicker(void)
{
}


LRESULT CALLBACK CColorPicker::WndProc(HWND hWnd, UINT uMessage, WPARAM wParam, LPARAM lParam)
{

	CColorPicker* pThis = NULL;
	if(IsWindow(hWnd))
	{
		pThis = (CColorPicker*)GetProp(hWnd, TEXT("clrpick_this"));
	}

	if(pThis || uMessage == WM_CREATE)
	{
		switch (uMessage)
		{
		case WM_KEYDOWN:
			if(wParam == VK_ESCAPE)
			{
				DestroyWindow(hWnd);
				return TRUE;
			}
			break;
		case WM_ACTIVATE:
			SetCapture(hWnd);
			break;
		case WM_CREATE:
			{
				LPCREATESTRUCT lpcs = (LPCREATESTRUCT)lParam;
				pThis = (CColorPicker*)(lpcs->lpCreateParams);
				SetProp(hWnd, TEXT("clrpick_this"), (HANDLE) pThis);
				pThis->m_hWnd = hWnd;
			}
			break;
		case WM_PAINT:
			pThis->OnPaint();
			break;
			//return TRUE;
		case WM_LBUTTONDOWN:
			pThis->OnLButtonDown(GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam));
			break;
		case WM_NCHITTEST:
			return HTCLIENT;
		case WM_MOUSEMOVE:
			pThis->OnMouseMove(wParam, GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam));
			return TRUE;
		}
	}

	return DefWindowProc(hWnd, uMessage, wParam, lParam);
}

void InitColorBtn(HINSTANCE hInst)
{
	WNDCLASS wc;
	if(!GetClassInfo(g_hInst, TEXT(TS_COLORPICKER_CLASS), &wc))
	{
		ZeroMemory(&wc, sizeof(wc));
		wc.style			= CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW | CS_SAVEBITS;
		wc.lpfnWndProc		= (WNDPROC) CColorPicker::WndProc;
		wc.cbClsExtra		= 0;
		wc.cbWndExtra		= 0;
		wc.hInstance		= hInst;
		wc.hIcon			= NULL;
		wc.hCursor			= LoadCursor(hInst, IDC_ARROW);
		wc.hbrBackground	= (HBRUSH)(COLOR_MENU+1);
		wc.lpszMenuName		= NULL;
		wc.lpszClassName	= TEXT(TS_COLORPICKER_CLASS);

		RegisterClass(&wc);
	}
}

void UninitColorBtn(HINSTANCE hInst)
{
	UnregisterClass(TEXT(TS_COLORPICKER_CLASS), hInst);
}

void CColorPicker::OnPaint()
{
	PAINTSTRUCT ps;
	BeginPaint(m_hWnd, &ps);

	HPEN pen = CreatePen(PS_SOLID, 1, 0);

	HPEN oldPen = (HPEN) SelectObject(ps.hdc, pen);

	for(DWORD i=0; i < 12; i++)
	{
		for(DWORD j=0; j < 18; j++)
		{
			HBRUSH br = CreateSolidBrush(m_colors[i][j]);
			RECT rc;
			rc.top = i * 10 + 20; rc.left = j * 10 + 1;
			rc.bottom = rc.top + 11;
			rc.right = rc.left + 11;

			HBRUSH oldBrush = (HBRUSH) SelectObject(ps.hdc, br);
			Rectangle(ps.hdc, rc.left, rc.top, rc.right, rc.bottom);
			SelectObject(ps.hdc, oldBrush);
			DeleteObject(br);
		}
	}

	SelectObject(ps.hdc, pen);
	HBRUSH oldBrush = (HBRUSH) SelectObject(ps.hdc, GetStockObject(HOLLOW_BRUSH));

	RECT rcButton;
	GetClientRect(m_hWnd, &rcButton);

	rcButton.top += 2; rcButton.bottom = rcButton.top + 16;
	rcButton.right -= 2; rcButton.left = rcButton.right - 16;

	Rectangle(ps.hdc, rcButton.left, rcButton.top, rcButton.right, rcButton.bottom);

	int x = rcButton.left + 6;
	int y = rcButton.top + 2;
	for(i=0; i < 6; i++)
	{
		MoveToEx(ps.hdc, x + i, y + i, NULL);
		LineTo(ps.hdc, x + i, y + 11 - i);
	}

	SelectObject(ps.hdc, oldPen);
	SelectObject(ps.hdc, oldBrush);

	DeleteObject(pen);

	EndPaint(m_hWnd, &ps);
}

void CColorPicker::Create(HWND hWndParent, COLORREF color)
{
	m_color = color;
	m_hWndParent = hWndParent;
	RECT rcWindow;
	GetWindowRect(hWndParent, &rcWindow);

	int y = rcWindow.bottom;
	int x = rcWindow.left;

	RECT rcDesktop;
	GetDesktopRect(&rcDesktop, m_hWndParent);
	if(y + 144 > rcDesktop.bottom)
	{
		y = rcWindow.top - 144;
	}

	CreateWindowEx(0,
					TEXT(TS_COLORPICKER_CLASS), NULL, 
					WS_POPUP | WS_VISIBLE | WS_BORDER, 
					x, y, 185, 144, hWndParent, NULL, g_hInst, (LPVOID) this);
	SetFocus(m_hWnd);
}

void CColorButton::OnClick(void)
{
	m_picker.Create(m_hWnd, m_color);
}

void CColorPicker::OnMouseMove(DWORD keys, int x, int y)
{
	POINT pt;
	pt.x = x;
	pt.y = y;

	RECT rcClient;
	GetClientRect(m_hWnd, &rcClient);
	if(!PtInRect(&rcClient, pt))
	{
		MapWindowPoints(m_hWnd, NULL, &pt, 1);
		HDC screenDC = GetDC(NULL);
		m_color = GetPixel(screenDC, pt.x, pt.y);
		DrawColorBar(NULL);
		ReleaseDC(NULL, screenDC);
		SetSelectedColor(-1, -1);
	} else
	{
		rcClient.top += 20;
		rcClient.bottom -= 2;
		rcClient.left += 2;
		rcClient.right += 2;
		if(PtInRect(&rcClient, pt))
		{
			int xx = (x - rcClient.left) / 10;
			int yy = (y - rcClient.top) / 10;
			if(xx >=0 && xx < 18 && yy >=0 && yy < 12)
			{
				m_color = m_colors[yy][xx];
				DrawColorBar(NULL);
				SetSelectedColor(xx, yy);
			}
		} else
		{
			SetSelectedColor(-1, -1);
		}
	}
}

void CColorPicker::DrawColorBar(HDC hdc)
{
	BOOL releaseDC = FALSE;
	if(!hdc)
	{
		hdc = GetDC(m_hWnd);
		releaseDC = TRUE;
	}

	HBRUSH br = CreateSolidBrush(m_color);

	RECT rc;
	rc.top = 2;
	rc.bottom = 18;
	rc.left = 2;
	rc.right = 50;

	HPEN pen = CreatePen(PS_SOLID, 1, 0);
	HPEN   oldPen = (HPEN) SelectObject(hdc, pen);
	HBRUSH oldBrush = (HBRUSH) SelectObject(hdc, br);

	Rectangle(hdc, rc.left, rc.top, rc.right, rc.bottom);

	SelectObject(hdc, oldPen);
	SelectObject(hdc, oldBrush);

	DeleteObject(br);
	DeleteObject(pen);

	if(releaseDC)
	{
		ReleaseDC(m_hWnd, hdc);
	}
}

void CColorPicker::DrawSelectedColor(HDC hdc, BOOL remove)
{
	if(selectedX < 0 || selectedY < 0) return;
	HPEN pen;
	if(remove)
	{
		pen = CreatePen(PS_SOLID, 1, 0);
	} else
	{
		pen = CreatePen(PS_SOLID, 1, RGB(0xFF, 0xFF, 0xFF));
	}
	HBRUSH br = CreateSolidBrush(m_colors[selectedY][selectedX]);

	HPEN   oldPen = (HPEN) SelectObject(hdc, pen);
	HBRUSH oldBrush = (HBRUSH) SelectObject(hdc, br);

	RECT rc;
	rc.top = selectedY * 10 + 20; rc.left = selectedX * 10 + 1;
	rc.bottom = rc.top + 11;
	rc.right = rc.left + 11;

	Rectangle(hdc, rc.left, rc.top, rc.right, rc.bottom);

	SelectObject(hdc, oldPen);
	SelectObject(hdc, oldBrush);

	DeleteObject(pen);
	DeleteObject(br);
}

void CColorPicker::SetSelectedColor(int x, int y)
{
	if(x != selectedX || y != selectedY)
	{
		HDC dc = GetDC(m_hWnd);
		DrawSelectedColor(dc, TRUE);
		selectedY = y;
		selectedX = x;
		DrawSelectedColor(dc, FALSE);
		ReleaseDC(m_hWnd, dc);
	}
}

void CColorButton::SelectColor(void)
{
	COLORREF custColors[16];
	ZeroMemory(custColors, sizeof(custColors));
	CHOOSECOLOR cc;
	ZeroMemory(&cc, sizeof(cc));
	cc.lStructSize = sizeof(cc);
	cc.Flags = CC_RGBINIT | CC_ANYCOLOR | CC_FULLOPEN;
	cc.hwndOwner = m_hWnd;
	cc.rgbResult = m_color;
	cc.lpCustColors = custColors;
	if(ChooseColor(&cc))
	{
		m_color = cc.rgbResult;
		InvalidateRect(m_hWnd, NULL, TRUE);
		SendMessage(GetParent(m_hWnd), WM_COMMAND, MAKELONG(GetDlgCtrlID(m_hWnd), BN_CLICKED), (LPARAM) m_hWnd);
	}
}

void CColorPicker::OnLButtonDown(int x, int y)
{
	RECT rcButton;
	GetClientRect(m_hWnd, &rcButton);
	rcButton.top += 2; rcButton.bottom = rcButton.top + 16;
	rcButton.right -= 2; rcButton.left = rcButton.right - 16;

	POINT pt;
	pt.x = x, pt.y = y;
	if(PtInRect(&rcButton, pt))
	{
		SendMessage(m_hWndParent, WM_USER + 2, m_color, 0);
	} else
	{
		SendMessage(m_hWndParent, WM_USER + 1, m_color, 0);
	}
	DestroyWindow(m_hWnd);
}

typedef HANDLE (WINAPI *MonitorFromWindowFNC)(HWND hwnd, DWORD dwFlags);
typedef BOOL (WINAPI *GetMonitorInfoFNC)(HANDLE hMonitor, LPMONITORINFO lpmi);

void CColorPicker::GetDesktopRect(RECT* rcDsk, HWND hWnd)
{
	int nMonitors = GetSystemMetrics(80);
	if(!nMonitors) nMonitors = 0;
	if(nMonitors == 1)
	{
oneMonitor:
		HWND dskWnd = GetDesktopWindow();
		GetClientRect(dskWnd, rcDsk);
	} else
	{
		HMODULE hUser32 = LoadLibrary(TEXT("user32.dll"));
		MonitorFromWindowFNC getMonitor = (MonitorFromWindowFNC) GetProcAddress(hUser32, "MonitorFromWindow");
		if(!getMonitor)
		{
			FreeLibrary(hUser32);
			goto oneMonitor;
		}
		HANDLE hMonitor = (*getMonitor)(hWnd, 0x00000002);
		if(!hMonitor)
		{
			FreeLibrary(hUser32);
			goto oneMonitor;
		}
		GetMonitorInfoFNC getMonitorInfo = (GetMonitorInfoFNC) GetProcAddress(hUser32, "GetMonitorInfoA");
		MONITORINFO mInf;
		mInf.cbSize = sizeof(MONITORINFO);
		(*getMonitorInfo)(hMonitor, &mInf);
		*rcDsk = mInf.rcMonitor;
		FreeLibrary(hUser32);
	}
}
