#pragma once

#include <windows.h>

#define TS_COLORPICKER_CLASS	"TrueSoftColorPickerClass"
extern void InitColorBtn(HINSTANCE hInst);
extern void UninitColorBtn(HINSTANCE hInst);

class CColorPicker
{
	COLORREF m_colors[12][18];
	HWND m_hWnd;
	COLORREF m_color;
	HWND m_hWndParent;

	int selectedX;
	int selectedY;

	void OnPaint();

	void GetDesktopRect(RECT* rcDsk, HWND hWnd);
public:
	static LRESULT CALLBACK WndProc(HWND hWnd, UINT uMessage, WPARAM wParam, LPARAM lParam);

	CColorPicker(void);
	virtual ~CColorPicker(void);
	void Create(HWND hWndParent, COLORREF color);
	void OnMouseMove(DWORD keys, int x, int y);
private:
	void DrawColorBar(HDC hdc);
	void DrawSelectedColor(HDC hdc, BOOL remove);
	void SetSelectedColor(int x, int y);
	void OnLButtonDown(int x, int y);
};

class CColorButton
{
	HWND			m_hWnd;
	WNDPROC			oldWndProc;
	COLORREF		m_color;
	CColorPicker	m_picker;

	static LRESULT CALLBACK WndProc(HWND hWnd, UINT uMessage, WPARAM wParam, LPARAM lParam);
public:
	COLORREF GetColor() { return m_color; }

	CColorButton(void);
	virtual ~CColorButton(void);

	void SubClassWindow(HWND hWnd, COLORREF color);
private:
	void OnPaint(void);
	void OnClick(void);
	void SelectColor(void);
};

