#include "StdAfx.h"
#include "vdesk.h"
#include <stdio.h>

#include "VirtualDesktop.h"

CVDesk::CVDesk(void)
{
	ZeroMemory(&m_layout, sizeof(m_layout));
}

CVDesk::~CVDesk(void)
{
	ClearLayout();
}

void CVDesk::ClearLayout()
{
	if(m_layout.fntLabel)
	{
		DeleteObject(m_layout.fntLabel);
	}

	ZeroMemory(&m_layout, sizeof(m_layout));
}

void CVDesk::RecalcLayout(int height, BTN_PROPERTIES& properties)
{
	ClearLayout();

	m_layout.height = height;
	m_layout.width = 0;

	LOGFONT lf;
	ZeroMemory(&lf, sizeof(lf));
	lf.lfHeight         = m_layout.height * 3 / 4 ;
	lf.lfWeight         = FW_BOLD;// FW_NORMAL;
	lf.lfCharSet        = ANSI_CHARSET;
	lf.lfOutPrecision   = OUT_CHARACTER_PRECIS;
	lf.lfClipPrecision  = CLIP_DEFAULT_PRECIS;
	lf.lfQuality        = ANTIALIASED_QUALITY;
	lf.lfPitchAndFamily = FF_DONTCARE;
	strcpy(lf.lfFaceName, properties.fontName);
	m_layout.fntLabel =  CreateFontIndirect(&lf);

	HDC dc = GetDC(NULL);
	HFONT oldFont = (HFONT) SelectObject(dc, m_layout.fntLabel);
	
	SIZE sz;
	GetTextExtentPoint32(dc, "9", 1, &sz);
	m_layout.width += sz.cx + 2;

    if( m_layout.width < m_layout.height )
    {
        m_layout.width = m_layout.height;
    }

	SelectObject(dc, oldFont);
	ReleaseDC(NULL, dc);
}

//===============================================================
//===============================================================
void CVDesk::DrawButton(HDC dc, int x, int y, int numVDesk, bool activ, 
    BOOL isOverDesktop, BTN_PROPERTIES& properties)
{
	HFONT fntOld = (HFONT) SelectObject(dc, m_layout.fntLabel);

	RECT rc;
	rc.top = y;
	rc.bottom = rc.top + m_layout.height;

	rc.left = x;
	rc.right = rc.left + m_layout.width;//!!!

	char drv[10];
	sprintf(drv, "%d", numVDesk);

	HBRUSH brush;

    if( isOverDesktop )
    {
        brush = CreateSolidBrush( properties.m_LigthColor );
    }
    else
    {
        if( activ )
        {
            brush = CreateSolidBrush( properties.m_SelectedColor );
        }
        else
        {
            if( virtualDesktop.GetCountHwndOnVDesktop(numVDesk - 1) )
            {
                brush = CreateSolidBrush( properties.m_UnSelectedColor );
            }
            else
            {
                brush = CreateSolidBrush( properties.m_FreeColor );
            }
        }
    }


    HBRUSH hOldBrush = (HBRUSH)SelectObject(dc, brush);
    
    FillRect(dc, &rc, brush);

    SetTextColor(dc, RGB(0, 0, 0) );
	DrawText(dc, drv, -1, &rc, DT_SINGLELINE | DT_VCENTER | DT_CENTER);
    
    SelectObject(dc, hOldBrush);
    DeleteObject(brush);

	SelectObject(dc, fntOld);
}
