#if !defined(AFX_VIRTUALDESKTOPBUTTON_H__9D008999_023E_419C_B748_5910B0EF3BC2__INCLUDED_)
#define AFX_VIRTUALDESKTOPBUTTON_H__9D008999_023E_419C_B748_5910B0EF3BC2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "vdesk.h"

class CVirtualDesktopButton : public ITlbButton  
{
public:
    CVirtualDesktopButton(void);
    virtual ~CVirtualDesktopButton(void);

	//IUnknown methods
	STDMETHODIMP QueryInterface(REFIID, LPVOID*);
	STDMETHODIMP_(DWORD) AddRef();
	STDMETHODIMP_(DWORD) Release();

	//ITlbButton methods
    STDMETHODIMP Load(IStream *data);
    STDMETHODIMP Save(IStream *data);
    STDMETHODIMP SetRect(RECT *rcItem);
    STDMETHODIMP SetContainer(ITlbContainer *cont);
    STDMETHODIMP SetID(int btnID);
    STDMETHODIMP Draw(HANDLE hDC, RECT *rcItem);
    STDMETHODIMP OnMouseOver(long keys, int x, int y);
    STDMETHODIMP OnMouseLeave(long keys);
    STDMETHODIMP OnMouseEnter(long keys, int x, int y);
	STDMETHODIMP Create(IStream* data);
	STDMETHODIMP StateChanged(int state, int* needRedraw);
	STDMETHODIMP GetDescription(char* szDescription);
	STDMETHODIMP OnLButtonDown(long key, int x, int y);
	STDMETHODIMP OnLButtonUp(long key, int x, int y);
	STDMETHODIMP Run();
	STDMETHODIMP DoAction(int action);
	STDMETHODIMP SetName(LPCSTR szName);
	STDMETHODIMP_(int) QueryContextMenu(HMENU hMenu, int index, int cmdFirst, int cmdLast);
	STDMETHODIMP InvokeCommand(int ID);
	STDMETHODIMP SetLCID(DWORD dwLCID, HMODULE hResModule);
	STDMETHODIMP GetIconLocation(LPSTR szLocation);
	STDMETHODIMP SetIconLocation(LPCSTR szLocation);
	STDMETHODIMP GetButtonInfo(BUTTONINFO* btninfo);
	STDMETHODIMP Invoke(DWORD id, WPARAM wParam, LPARAM lParam);

protected:
	DWORD   m_ObjRefCount;

private:
	DWORD   m_version;
    RECT    m_rc;
	DWORD   m_ID;
	DWORD   m_state;
	char    m_Name[MAX_PATH];
	HMODULE m_hResource;

	ITlbContainer* m_container;

	CRITICAL_SECTION m_sync;
	void LockItems() { EnterCriticalSection(&m_sync); }
	void UnlockItems() { LeaveCriticalSection(&m_sync); }

    HANDLE m_mutex;
    DWORD  m_mutex_error;

    CVDesk  m_vDesk;
	int		m_rows;
	int		m_cols;

	BTN_PROPERTIES m_properties;
	int m_overDesktop;

	void RecalcLayout(int height);
    int  FindDesktopXY(int x, int y);

    void FillToolTip(char *strTooltip);
};

#endif // !defined(AFX_VIRTUALDESKTOPBUTTON_H__9D008999_023E_419C_B748_5910B0EF3BC2__INCLUDED_)
