// VirtualDesktop.h: interface for the CVirtualDesktop class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VIRTUALDESKTOP_H__CE871E8B_C4CF_4D94_924F_80068FDD1DD1__INCLUDED_)
#define AFX_VIRTUALDESKTOP_H__CE871E8B_C4CF_4D94_924F_80068FDD1DD1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <assert.h>

struct CDesktopWindow
{
    HWND  m_hwnd;
    DWORD m_reserv1;
    DWORD m_reserv2;
};

const int MAX_COUNT_WINDOW  = 1000;
const int MAX_COUNT_DESKTOP = 9;

class CVirtualDesktop  
{
    friend BOOL CALLBACK EnumWindowsProc( HWND hwnd,  LPARAM lParam );
    
public:
	CVirtualDesktop();
	virtual ~CVirtualDesktop();

    bool Create(int newCountDesktop);
    bool SetCountDesktop(int newCountDesktop);
    
    int GetCountDesktop()
    {
        return m_countDesktop;
    }

    int GetActiveDesktop()
    {
        return m_activeDesktop;
    }
    
    void SetActiveDesktop(int numDesktop)
    {
        m_activeDesktop = numDesktop;
    }

    int GetCountHwndOnVDesktop(int index)
    {
        assert(index < MAX_COUNT_DESKTOP);
        assert(index >= 0);

        return m_countWindow[index];
    }

    void SetCountHwndOnVDesktop(int index, int count)
    {
        assert(index < MAX_COUNT_DESKTOP);
        assert(index >= 0);

        m_countWindow[index] = count;
    }

    void GetVDesktopWindow(int indexVDesktop, int indexWindow, CDesktopWindow* dWindow);
    void SetVDesktopWindow(int indexVDesktop, int indexWindow, const CDesktopWindow& dWindow);

    bool ShowDesktop(int index, HWND notHideWindow);
    
    bool ShowAllWindow();
protected:
    int m_activeDesktop;    //  
    int m_countDesktop;     // 

    int m_countWindow[MAX_COUNT_DESKTOP];

    CDesktopWindow m_windowList[MAX_COUNT_DESKTOP][MAX_COUNT_WINDOW];

    HWND m_hwndSysTray;
    HWND m_hwndProgram;
    HWND m_hwndDesktop;
    HWND m_notHideWindow;

    bool GetWindowList(int index);
};


extern CVirtualDesktop virtualDesktop;

#endif // !defined(AFX_VIRTUALDESKTOP_H__CE871E8B_C4CF_4D94_924F_80068FDD1DD1__INCLUDED_)
