#include "StdAfx.h"
#include "virtualdesktopbutton.h"
#include "Global.h"
#include "PropertiesDlg.h"
#include "VirtualDesktop.h"

const char VDESKTOP_MUTEX[] = "85FC560F-B98D-4656-AA79-41F0E1CCA920";

CVirtualDesktopButton::CVirtualDesktopButton(void)
{
	m_ObjRefCount = 1;
	g_DllRefCount++;

	m_version = 1;
	m_ID = 0;
	m_state = 0;
    m_Name[0] = 0;
	m_hResource = g_hInst;
	m_container = NULL;

	m_rows = 2;
	m_cols = 2;
    
    m_overDesktop = -1;

	ZeroMemory(&m_properties, sizeof(BTN_PROPERTIES));
	m_properties.m_cbSize = sizeof(BTN_PROPERTIES);
	m_properties.m_cols            = m_cols;
    m_properties.m_desktops        = m_rows * m_cols;
    m_properties.m_FreeColor       = RGB(211, 211, 211);
    m_properties.m_LigthColor      = RGB(0xFF, 0xFF, 0xFF);
    m_properties.m_SelectedColor   = RGB(0, 255, 255);
    m_properties.m_UnSelectedColor = RGB(128, 128, 128);
	strcpy(m_properties.fontName, "Tahoma");

    virtualDesktop.Create(m_properties.m_desktops);

    ::InitializeCriticalSection(&m_sync);

    m_mutex       = ::CreateMutex(NULL, FALSE, VDESKTOP_MUTEX);
    m_mutex_error = GetLastError();
}

CVirtualDesktopButton::~CVirtualDesktopButton(void)
{
    virtualDesktop.ShowAllWindow();

    ::CloseHandle(m_mutex);
    ::DeleteCriticalSection(&m_sync);

	g_DllRefCount--;
}

//=====================================
//IUnknown methods
//=====================================
STDMETHODIMP CVirtualDesktopButton::QueryInterface(REFIID riid, LPVOID*ppReturn)
{
	*ppReturn = NULL;

	//IUnknown
	if(IsEqualIID(riid, IID_ITlbButton))
	   {
	   *ppReturn = (IDataObject*) this;
	   }

	if(IsEqualIID(riid, IID_IUnknown))
	   {
	   *ppReturn = (IUnknown*) this;
	   }

	if(*ppReturn)
	   {
	   (*(LPUNKNOWN*)ppReturn)->AddRef();
	   return S_OK;
	   }

	return E_NOINTERFACE;
}

//=====================================
//=====================================
STDMETHODIMP_(DWORD) CVirtualDesktopButton::AddRef()
{
	return ++m_ObjRefCount;
}

//=====================================
//=====================================
STDMETHODIMP_(DWORD) CVirtualDesktopButton::Release()
{
	if(--m_ObjRefCount == 0)
	{
		delete this;
		return 0;
	}
	return m_ObjRefCount;
}

//=====================================
//ITlbButton methods
//=====================================
STDMETHODIMP CVirtualDesktopButton::Load(IStream *data)
{
	DWORD loadedVersion = 0;
	ULONG cbRead = 0;

	data->Read(&loadedVersion, sizeof(DWORD), &cbRead);
	data->Read(&m_properties, sizeof(m_properties), &cbRead);//!!!
    
    DWORD countDesktop;
    data->Read(&countDesktop, sizeof(countDesktop), &cbRead);
    virtualDesktop.Create(countDesktop);

    //read number active desktop
    bool readActiveDesktop = false;
    DWORD activeDesktop;
    data->Read(&activeDesktop, sizeof(activeDesktop), &cbRead );
    if( cbRead == sizeof(activeDesktop) )
    {
        readActiveDesktop = true;
    }

    //read count window on desktops 
    bool readCountWin = true;
    DWORD countWindow[MAX_COUNT_DESKTOP];
    for(int i = 0; i < MAX_COUNT_DESKTOP; i++ )
    {
        data->Read(&countWindow[i], sizeof(countWindow[i]), &cbRead);
        if( cbRead != sizeof(countWindow[i]) )
        {
            readCountWin = false;
        }
    }

    //read params windwos on desktops 
    bool readParamWin = true;
    CDesktopWindow dWin[MAX_COUNT_DESKTOP][MAX_COUNT_WINDOW];
    for(int i = 0; i < MAX_COUNT_DESKTOP; i++)
    {
        for( unsigned int j = 0; j < countWindow[i]; j++ )
        {
            data->Read( &dWin[i][j], sizeof(CDesktopWindow), &cbRead );
            if( cbRead != sizeof(CDesktopWindow) )
            {
                readParamWin = false;
            }
        }
    }

    //init virtual desktop
    if( readActiveDesktop && readCountWin && readParamWin )
    {
        virtualDesktop.SetActiveDesktop(activeDesktop);

        for(int i = 0; i < MAX_COUNT_DESKTOP; i++ )
        {
            virtualDesktop.SetCountHwndOnVDesktop(i, countWindow[i]);
            for( unsigned int j = 0; j < countWindow[i]; j++ )
            {
                virtualDesktop.SetVDesktopWindow(i, j, dWin[i][j]);
            }
        }
    }
	return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::Save(IStream *data)
{
	ULONG cbWritten;
	data->Write(&m_version, sizeof(DWORD), &cbWritten);
    data->Write(&m_properties, sizeof(m_properties), &cbWritten );//!!!

    DWORD countDesktop = virtualDesktop.GetCountDesktop();
    data->Write(&countDesktop, sizeof(countDesktop), &cbWritten);

    DWORD activeDesktop = virtualDesktop.GetActiveDesktop();
    data->Write(&activeDesktop, sizeof(activeDesktop), &cbWritten );

    for(int i = 0; i < MAX_COUNT_DESKTOP; i++ )
    {
        DWORD countWindow = virtualDesktop.GetCountHwndOnVDesktop(i);
        data->Write(&countWindow, sizeof(countWindow), &cbWritten );
    }

    for( int i = 0; i < MAX_COUNT_DESKTOP; i++ )
    {
        for(int j = 0; j < virtualDesktop.GetCountHwndOnVDesktop(i); j++ )
        {
            CDesktopWindow dWin;
            virtualDesktop.GetVDesktopWindow(i, j, &dWin);

            data->Write( &dWin, sizeof(dWin), &cbWritten );
        }
    }
	return S_OK;
}

//=====================================
// Sets button rectangle
//=====================================
STDMETHODIMP CVirtualDesktopButton::SetRect(RECT *rcItem)
{
	m_rc = rcItem[0];
	return S_OK;
}

//=====================================
// Set button container
// NOTE: do not call AddRef to store container pointer
//=====================================
STDMETHODIMP CVirtualDesktopButton::SetContainer(ITlbContainer *cont)
{
	m_container = cont;
	return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::SetID(int btnID)
{
	m_ID = btnID;
	return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::Draw(HANDLE hDC, RECT *rcItem)
{
	HDC dc = (HDC) hDC;

	COLORREF color = 0;
	RECT marging;
	if(m_container)
	{
		m_container->GetTextProps(&marging, &color);
	}

	SetTextColor(dc, color);
	SetBkMode(dc, TRANSPARENT);

	LockItems();

    int index = 0;
	int y = rcItem->top;

	for(int row = 0; row < m_rows; row++ )
    {
    	int x = rcItem->left;
		if( index >= virtualDesktop.GetCountDesktop() ) 
            break;

        for(int col = 0; col < m_cols; col++ )
        {
		    if( index >= virtualDesktop.GetCountDesktop() ) 
                break;

        	m_vDesk.DrawButton(dc, x, y, index + 1, index == virtualDesktop.GetActiveDesktop(),
                index == m_overDesktop, m_properties);
    		x += m_vDesk.m_layout.width;
            index++;
        }
		y += m_vDesk.m_layout.height;
    }
    UnlockItems();

	return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::OnMouseOver(long keys, int x, int y)
{
	int overDesktop = FindDesktopXY(x, y);
	if(m_overDesktop != overDesktop)
	{
		m_overDesktop = overDesktop;
		m_container->UpdateButtonInfo(UPDATE_REDRAW);
	}

	return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::OnMouseLeave(long keys)
{
	if(m_overDesktop >= 0)
	{
		m_overDesktop = -1;
		m_container->UpdateButtonInfo(UPDATE_REDRAW);
	}
	return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::OnMouseEnter(long keys, int x, int y)
{
	return S_FALSE;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::Create(IStream* data)
{
    if( m_mutex_error == ERROR_ALREADY_EXISTS )
    {
        return S_FALSE;
    }
	if(m_container)
	{
		HWND hWndBand = m_container->GetBandWND();

		CPropertiesDlg dlg;
		dlg.m_props     = m_properties;
		dlg.m_hResource = m_hResource;
		if(dlg.DoModal(hWndBand, m_hResource) == IDOK)
		{
			LockItems();
			m_properties = dlg.m_props;
            virtualDesktop.SetCountDesktop(m_properties.m_desktops);
			UnlockItems();

			//m_container->UpdateButtonInfo(UPDATE_SIZE | UPDATE_REDRAW);
		}
		return Save(data);
	}
	return S_FALSE;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::StateChanged(int state, int* needRedraw)
{
	needRedraw[0] = TRUE;
	m_state = state;
	return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::GetDescription(char* szDescription)
{
	if(szDescription)
	{
		strcpy(szDescription, m_Name);
		return S_OK;
	}
	return S_FALSE;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::OnLButtonDown(long key, int x, int y)
{
	return S_FALSE;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::OnLButtonUp(long key, int x, int y)
{
	LockItems();

	int overdesktop = FindDesktopXY(x, y);

    if( overdesktop >= 0 )
    {
        if(virtualDesktop.GetActiveDesktop() != overdesktop )
        {
            HWND myHwnd = m_container->GetBandWND();

            HWND parentHwnd = ::GetParent(myHwnd);
            if( parentHwnd )
            {
                while(true)
                {
                    HWND tmpParent = ::GetParent(parentHwnd);
                    if( tmpParent == NULL)
                    {
                        break;
                    }
                    else
                    {
                        parentHwnd = tmpParent;
                    }
                }
            }
            else
            {
                parentHwnd = myHwnd;
            }

            virtualDesktop.ShowDesktop(overdesktop, parentHwnd);
            m_container->SaveButton();
            m_container->UpdateButtonInfo(UPDATE_REDRAW);
        }
    }

    UnlockItems();

    return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::Run()
{
	return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::DoAction(int action)
{
	if(action == CTMS_PROPERTIES)
	{
		if( m_container )
		{
			HWND hWndBand = m_container->GetBandWND();

			CPropertiesDlg dlg;
			dlg.m_props     = m_properties;
			dlg.m_hResource = m_hResource;
			if(dlg.DoModal(hWndBand, m_hResource) == IDOK)
			{
			    LockItems();
                
                if( m_properties.m_desktops > dlg.m_props.m_desktops )
                {
                    HWND myHwnd = m_container->GetBandWND();

                    HWND parentHwnd = ::GetParent(myHwnd);
                    if( parentHwnd )
                    {
                        while(true)
                        {
                            HWND tmpParent = ::GetParent(parentHwnd);
                            if( tmpParent == NULL)
                            {
                                break;
                            }
                            else
                            {
                                parentHwnd = tmpParent;
                            }
                        }
                    }
                    else
                    {
                        parentHwnd = myHwnd;
                    }
                    virtualDesktop.ShowDesktop(0, parentHwnd);
                }

			    m_properties = dlg.m_props;
                virtualDesktop.SetCountDesktop(m_properties.m_desktops);

			    UnlockItems();

				m_container->UpdateButtonInfo(UPDATE_SIZE | UPDATE_REDRAW);
				m_container->SaveButton();
			}
		}
	}
	return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::SetName(LPCSTR szName)
{
	strcpy(m_Name, szName);
	return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP_(int) CVirtualDesktopButton::QueryContextMenu(HMENU hMenu, int index, int cmdFirst, int cmdLast)
{
    return 0;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::InvokeCommand(int ID)
{
	return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::SetLCID(DWORD dwLCID, HMODULE hResModule)
{
	if(!hResModule)
	{
		m_hResource = g_hInst;
	} 
    else
	{
		m_hResource = hResModule;
	}
	return S_OK;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::GetIconLocation(LPSTR szLocation)
{
	return S_FALSE;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::SetIconLocation(LPCSTR szLocation)
{
	return S_FALSE;
}

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::GetButtonInfo(BUTTONINFO* btninfo)
{
	if(btninfo->dwMask & BTNINFO_MASK_MODEFLAG)
	{
		btninfo->dwModeFlags = BTN_FLAG_PLANE;
	}

	if(btninfo->dwMask & BTNINFO_MASK_ACTIONS)
	{
		btninfo->dwActions = CTMS_PROPERTIES;
	}

	if(btninfo->dwMask & BTNINFO_MASK_SIZE ||
	   btninfo->dwMask & BTNINFO_MASK_ACTUALSIZE)
	{
		RecalcLayout(btninfo->szBtnSize.cy);
		btninfo->szBtnSize.cx = m_vDesk.m_layout.width * m_cols;
	}

	if(btninfo->dwMask & BTNINFO_MASK_DESCRIPTION)
	{
		char* szDescription = (char*) btninfo->strData;
		strcpy(szDescription, m_Name);
	}
	return S_OK;
}

//=====================================
//=====================================
const char TRUE_LAUNCNBAR_MENU1[]   = "TrueLaunchBarMenu";
const char TRUE_LAUNCNBAR_SHADOW1[] = "TrueLaunchBarShadow";
const char MICROSOFT_NET_WINDOW[]   = "wndclass_desked_gsk";
const char MY_TOOLTIP_CLASS32[]     = "tooltips_class32";

//=====================================
//=====================================
STDMETHODIMP CVirtualDesktopButton::Invoke(DWORD id, WPARAM wParam, LPARAM lParam)
{
	switch(id)
	{
	case TBTN_INVOKE_GETTOOLTIPSCOUNT:
        {
            int *count = (int*)lParam;
            *count = virtualDesktop.GetCountDesktop();
    		return S_OK;
        }

	case TBTN_INVOKE_GETTOOLTIPRECT:
        {
			int row = wParam / m_cols;
			int col = wParam - row * m_rows;

            LPRECT rc  = (LPRECT) lParam;
            rc->left   = m_rc.left   + col * m_vDesk.m_layout.width;
            rc->top    = m_rc.top    + row * m_vDesk.m_layout.height;
            rc->right  = rc->left  + m_vDesk.m_layout.width;
            rc->bottom = rc->top + m_vDesk.m_layout.height;

    		return S_OK;
        }

	case TBTN_INVOKE_GETTOOLTIPTEXT:
        {
			char* str = (char*) lParam;

            str[0] = 0;

            if( wParam == virtualDesktop.GetActiveDesktop() )
            {
                FillToolTip(str);
                return S_OK;
            }
            
            if( ( wParam >= 0 ) && ( wParam < (unsigned)virtualDesktop.GetCountDesktop() ) )
            {
                int countWindow = virtualDesktop.GetCountHwndOnVDesktop(wParam);
                for(int i = 0; i < countWindow; i++ )
                {
                    char windowTitle[100];
                    char buf[100];
                    CDesktopWindow dWin;

                    virtualDesktop.GetVDesktopWindow(wParam, i, &dWin);
                    ::GetWindowText(dWin.m_hwnd, windowTitle, 100);

		            if(windowTitle[0])
		            {
                        char className[100];
                        ::GetClassName(dWin.m_hwnd, className, 100);

                        if( i == countWindow - 1 )
                        {
                            if( strcmp(className, MICROSOFT_NET_WINDOW) )
                            {
                                sprintf(buf, "* %s", windowTitle );
                                strcat(str, buf);
                            }
                        }
                        else
                        {
                            if( strcmp(className, MICROSOFT_NET_WINDOW) )
                            {
                                sprintf(buf, "* %s\n", windowTitle );
                                strcat(str, buf);
                            }
                        }
                    }
                }

                if( countWindow == 0 )
                {
                    strcpy(str, "<empty>");
                }
            }
    		return S_OK;
        }
	}

	return S_FALSE;
}


//=====================================
//=====================================
int  countWindowActiveDesktop = 0;
HWND windowActiveDesktop[MAX_COUNT_WINDOW];
HWND hwndSysTray;
HWND hwndProgram;
HWND hwndDesktop;

BOOL CALLBACK EnumWindowsProc1( HWND hwnd,  LPARAM lParam )
{
    HWND tmpHWND = hwnd;

    if( ::IsWindowVisible(tmpHWND) )
    {
        char className[200];
        ::GetClassName(tmpHWND, className, 199);

        if( !strcmp(className, TRUE_LAUNCNBAR_MENU1 )  )
        {
            return TRUE;
        }

        if( !strcmp(className, TRUE_LAUNCNBAR_SHADOW1 )  )
        {
            return TRUE;
        }

        if( !strcmp(className, MICROSOFT_NET_WINDOW) )
        {
            return TRUE;
        }

        if( !strcmp(className, MY_TOOLTIP_CLASS32) )
        {
            return TRUE;
        }

        if( ( tmpHWND != hwndSysTray ) && 
            ( tmpHWND != hwndProgram )  )
        {
            windowActiveDesktop[countWindowActiveDesktop++] = tmpHWND;
        }
    }
        
	return TRUE;
}

void CVirtualDesktopButton::FillToolTip(char *strTooltip)
{
    hwndSysTray = ::FindWindow("Shell_TrayWnd", NULL);
    hwndProgram = ::FindWindow("Progman", NULL);
    hwndDesktop = ::GetDesktopWindow();

    countWindowActiveDesktop = 0;
    memset(windowActiveDesktop, 0, sizeof(windowActiveDesktop) );

    EnumWindows(EnumWindowsProc1, 0);

    for( int i = 0; i < countWindowActiveDesktop; i++ )
    {
        char windowTitle[100];
        char buf[100];

        ::GetWindowText(windowActiveDesktop[i], windowTitle, 100);
		if(windowTitle[0])
		{
			if( i == countWindowActiveDesktop - 1 )
			{
				sprintf(buf, "* %s", windowTitle );
				strcat(strTooltip, buf);
			}
			else
			{
				sprintf(buf, "* %s\n", windowTitle );
				strcat(strTooltip, buf);
			}
		}
    }

    if( countWindowActiveDesktop == 0 )
    {
        strcpy(strTooltip, "<empty>");
    }
}

//=====================================
//=====================================
void CVirtualDesktopButton::RecalcLayout(int height)
{
	m_cols = m_properties.m_cols;
	if( m_cols > virtualDesktop.GetCountDesktop() ) 
        m_cols = virtualDesktop.GetCountDesktop();

	if( !m_cols ) 
        m_cols = 1;

	m_rows = virtualDesktop.GetCountDesktop() / m_cols;
	if( m_cols * m_rows < virtualDesktop.GetCountDesktop() ) 
        m_rows++;

	m_vDesk.RecalcLayout(height / m_rows, m_properties);
}

//=====================================
//=====================================
int CVirtualDesktopButton::FindDesktopXY(int x, int y)
{
	int col = (x - m_rc.left) / (m_vDesk.m_layout.width ? m_vDesk.m_layout.width : 1);
	int row = (y - m_rc.top) / (m_vDesk.m_layout.height ? m_vDesk.m_layout.height : 1);

	int retDesktop = row * m_cols + col;

    if( retDesktop >= virtualDesktop.GetCountDesktop() )
        retDesktop = -1;

	return retDesktop;
}
