//=================================================================================
// Virtual Desktop Plugin for True Launch Bar
// v.0.11
// 
// 
//=================================================================================


#include "stdafx.h"
#include "vdesktop.h"
#include "Global.h"
#include "CLSFACT.h"

/**************************************************************************
   GUID stuff
**************************************************************************/

//this part is only done once
//if you need to use the GUID in another file, just include Guid.h
#pragma data_seg(".text")
#define INITGUID
#include <initguid.h>
#include <shlguid.h>
#include "Guid.h"
#pragma data_seg()

/**************************************************************************
   global variables
**************************************************************************/

HINSTANCE   g_hResInst = NULL;
HINSTANCE   g_hInst = NULL;
UINT        g_DllRefCount = 0;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		g_hInst = (HINSTANCE) hModule;
		g_hResInst = (HINSTANCE) hModule;
		InitColorBtn(g_hInst);
		break;

	case DLL_PROCESS_DETACH:
		if(g_hResInst && g_hResInst != g_hInst)
		{
			UninitColorBtn(g_hInst);
			FreeLibrary(g_hResInst);
			g_hResInst = g_hInst;
		}
		break;
	}
    return TRUE;
}


/**************************************************************************

   DllRegisterServer

**************************************************************************/


STDAPI DllRegisterServer(void)
{
	if(RegisterPlugin(g_hInst, CLSID_VirtualDesktop, "Virtual Desktop") != S_OK)
	{
		return SELFREG_E_CLASS;
	}
	return S_OK;
}

/**************************************************************************

   DllUnregisterServer

**************************************************************************/

STDAPI DllUnregisterServer(void)
{
	if(!UnregisterPlugin(CLSID_VirtualDesktop))
	   return SELFREG_E_CLASS;

	return S_OK;
}


/**************************************************************************

   DllCanUnloadNow

**************************************************************************/

STDAPI DllCanUnloadNow(void)
{
	return (g_DllRefCount ? S_FALSE : S_OK);
}

/**************************************************************************

   DllGetClassObject

**************************************************************************/

STDAPI DllGetClassObject(  REFCLSID rclsid, 
                           REFIID riid, 
                           LPVOID *ppReturn)
{
	*ppReturn = NULL;

	//if we don't support this classid, return the proper error code
	if(!IsEqualCLSID(rclsid, CLSID_VirtualDesktop))
	   return CLASS_E_CLASSNOTAVAILABLE;
   
	//create a CClassFactory object and check it for validity
	CClassFactory *pClassFactory = new CClassFactory(rclsid);
	if(NULL == pClassFactory)
	   return E_OUTOFMEMORY;
   
	//get the QueryInterface return for our return value
	HRESULT hResult = pClassFactory->QueryInterface(riid, ppReturn);

	//call Release to decement the ref count - creating the object set it to one 
	//and QueryInterface incremented it - since its being used externally (not by 
	//us), we only want the ref count to be 1
	pClassFactory->Release();

	//return the result from QueryInterface
	return hResult;
}
